import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import * as React from 'react';
import { ChevronLeft, ChevronRight } from '@strapi/icons';
import styled from 'styled-components';
import { KeyboardKeys } from '../helpers/keyboardKeys.mjs';
import { Tooltip } from '../Tooltip/Tooltip.mjs';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Icon } from '../Icon/Icon.mjs';
import { Typography } from '../Typography/Typography.mjs';

const CarouselGrid = styled(Box) `
  grid-template-columns: auto 1fr auto;
  grid-template-areas: 'startAction slides endAction';
`;
const CarouselSlides = styled(Flex) `
  grid-area: slides;
`;
const CarouselAction = styled(Box) `
  grid-area: ${({ area }) => area};

  &:focus svg path,
  &:hover svg path {
    fill: ${({ theme }) => theme.colors.neutral900};
  }
`;
const Carousel = React.forwardRef(({ actions, children, label, nextLabel, onNext, onPrevious, previousLabel, secondaryLabel, selectedSlide, ...props }, forwardedRef) => {
    const prevActionRef = React.useRef(null);
    const nextActionRef = React.useRef(null);
    const childrenArray = React.Children.map(children, (node, index) => React.cloneElement(node, { selected: index === selectedSlide }));
    const handleKeyDown = (event) => {
        switch (event.key) {
            case KeyboardKeys.RIGHT: {
                event.preventDefault();
                if (nextActionRef?.current) {
                    nextActionRef.current.focus();
                }
                onNext();
                break;
            }
            case KeyboardKeys.LEFT: {
                event.preventDefault();
                if (prevActionRef?.current) {
                    prevActionRef.current.focus();
                }
                onPrevious();
                break;
            }
        }
    };
    return (jsx(Box, { ref: forwardedRef, ...props, onKeyDown: handleKeyDown, children: jsxs(Box, { padding: 2, borderColor: "neutral200", hasRadius: true, background: "neutral100", children: [jsxs(CarouselGrid, { as: "section", "aria-roledescription": "carousel", "aria-label": label, display: "grid", position: "relative", children: [childrenArray && childrenArray.length > 1 && (jsxs(Fragment, { children: [jsx(CarouselAction, { as: "button", onClick: onPrevious, area: "startAction", ref: prevActionRef, "aria-label": previousLabel, type: "button", children: jsx(Icon, { as: ChevronLeft, "aria-hidden": true, width: "6px", height: "10px", color: "neutral600" }) }), jsx(CarouselAction, { as: "button", onClick: onNext, area: "endAction", ref: nextActionRef, "aria-label": nextLabel, type: "button", children: jsx(Icon, { as: ChevronRight, "aria-hidden": true, width: "6px", height: "10px", color: "neutral600" }) })] })), jsx(CarouselSlides, { "aria-live": "polite", paddingLeft: 2, paddingRight: 2, width: "100%", overflow: "hidden", children: childrenArray }), actions] }), secondaryLabel && (jsx(Box, { paddingTop: 2, paddingLeft: 4, paddingRight: 4, children: jsx(Tooltip, { label: secondaryLabel, children: jsx(Flex, { justifyContent: "center", children: jsx(Typography, { variant: "pi", textColor: "neutral600", ellipsis: true, children: secondaryLabel }) }) }) }))] }) }));
});

export { Carousel };
