import { jsx } from 'react/jsx-runtime';
import { CardAction } from './CardAction.mjs';
import { useCard } from './CardContext.mjs';
import { BaseCheckbox } from '../BaseCheckbox/BaseCheckbox.mjs';

const CardCheckbox = (props) => {
    const { id } = useCard();
    return (
    // @ts-expect-error styled-components can't overwrite the position prop from Stack
    jsx(CardAction, { position: "start", children: jsx(BaseCheckbox, { "aria-labelledby": `${id}-title`, ...props }) }));
};

export { CardCheckbox };
