'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const CardContext = require('./CardContext.js');
const useId = require('../hooks/useId.js');
const Box = require('../Box/Box.js');

const Card = ({ id, ...props }) => {
    const generatedId = useId.useId(id);
    const context = React.useMemo(() => ({ id: generatedId }), [generatedId]);
    return (jsxRuntime.jsx(CardContext.CardContext.Provider, { value: context, children: jsxRuntime.jsx(Box.Box, { id: id, tabIndex: 0, hasRadius: true, background: "neutral0", borderStyle: "solid", borderWidth: "1px", borderColor: "neutral150", shadow: "tableShadow", as: "article", "aria-labelledby": `${generatedId}-title`, ...props }) }));
};

exports.Card = Card;
