import { jsx } from 'react/jsx-runtime';
import { useRef, useLayoutEffect, useMemo } from 'react';
import { RadioContext } from './context.mjs';
import { setTabIndexOnFirstItem } from '../helpers/setTabIndexOnFirstItem.mjs';

const RadioGroup = ({ children, labelledBy, onChange, value = '', size = 'M', name, ...props }) => {
    const radioGroupRef = useRef(null);
    useLayoutEffect(() => {
        if (!value) {
            setTabIndexOnFirstItem(radioGroupRef.current, `[name="${name}"]`);
        }
    }, [value, name]);
    const context = useMemo(() => ({ onChange, selected: value, name, size }), [name, onChange, size, value]);
    return (jsx(RadioContext.Provider, { value: context, children: jsx("div", { ref: radioGroupRef, role: "radiogroup", "aria-labelledby": labelledBy, ...props, children: children }) }));
};

export { RadioGroup };
