'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const context = require('./context.js');
const utils = require('./utils.js');
const useId = require('../hooks/useId.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const RadioInput = styled__default.default.input `
  margin: 0;
  padding: 0;
  background-color: ${({ theme }) => theme.colors.neutral0};
  border: 1px solid ${({ theme }) => theme.colors.primary600};
  border-radius: 50%;
  height: ${({ size }) => (typeof size === 'number' ? size : utils.getRadioSize(size))};
  width: ${({ size }) => (typeof size === 'number' ? size : utils.getRadioSize(size))};
  -webkit-appearance: none;

  &:after {
    border-radius: 50%;
    content: '';
    position: relative;
    z-index: 1;
    display: block;
    height: ${({ size }) => (typeof size === 'number' ? size : utils.getSelectedRadioSize(size))};
    width: ${({ size }) => (typeof size === 'number' ? size : utils.getSelectedRadioSize(size))};
    left: ${utils.getSelectedRadioPosition};
    top: ${utils.getSelectedRadioPosition};
  }

  &:checked:after {
    background: ${({ theme }) => theme.colors.primary600};
  }

  &:disabled {
    border: 1px solid ${({ theme }) => theme.colors.neutral300};
    background: ${({ theme }) => theme.colors.neutral200};
  }
`;
const BaseRadio = React__default.default.forwardRef(({ value, disabled = false, ...props }, ref) => {
    const generatedId = useId.useId();
    const { onChange, selected, name, size } = React.useContext(context.RadioContext);
    const isSelected = selected === value;
    return (jsxRuntime.jsx(RadioInput, { ref: ref, type: "radio", name: name, value: value, tabIndex: isSelected ? 0 : -1, "aria-checked": isSelected, checked: isSelected, disabled: disabled, id: generatedId, 
        // @ts-expect-error size is a html prop already.
        size: size, onChange: onChange, ...props }));
});
BaseRadio.displayName = 'Radio';

exports.BaseRadio = BaseRadio;
