import { jsx } from 'react/jsx-runtime';
import React__default from 'react';
import { Box } from '../Box/Box.mjs';

const BaseLink = React__default.forwardRef(({ href, rel = 'noreferrer noopener', target = '_self', disabled = false, isExternal = false, ...props }, ref) => {
    return (jsx(Box, { as: "a", ref: ref, target: isExternal ? '_blank' : target, rel: isExternal ? rel : undefined, href: disabled ? '#' : href, "aria-disabled": disabled, cursor: "pointer", ...props }));
});
BaseLink.displayName = 'BaseLink';

export { BaseLink };
