'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const checkmarkBlack = require('./assets/checkmark-black.svg.js');
const checkmark = require('./assets/checkmark.svg.js');
const utils = require('./utils.js');
const useComposeRefs = require('../hooks/useComposeRefs.js');
const Box = require('../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const CheckboxInput = styled__default.default.input `
  height: ${utils.getCheckboxSize};
  min-width: ${utils.getCheckboxSize};
  margin: 0;
  border-radius: ${({ theme }) => theme.borderRadius};
  border: 1px solid ${({ theme }) => theme.colors.neutral300};
  -webkit-appearance: none;
  background-color: ${({ theme }) => theme.colors.neutral0};
  cursor: pointer;

  &:checked {
    background-color: ${({ theme }) => theme.colors.primary600};
    border: 1px solid ${({ theme }) => theme.colors.primary600};

    &:after {
      content: '';
      display: block;
      position: relative;
      background: ${() => `url("${checkmark}") no-repeat no-repeat center center`};
      width: 10px;
      height: 10px;
      left: 50%;
      top: 50%;
      transform: translateX(-50%) translateY(-50%);
    }

    &:disabled:after {
      background: ${() => `url("${checkmarkBlack}") no-repeat no-repeat center center`};
    }
  }

  &:disabled {
    background-color: ${({ theme }) => theme.colors.neutral200};
    border: 1px solid ${({ theme }) => theme.colors.neutral300};
  }

  &:indeterminate {
    background-color: ${({ theme }) => theme.colors.primary600};
    border: 1px solid ${({ theme }) => theme.colors.primary600};

    &:after {
      content: '';
      display: block;
      position: relative;
      color: white;
      height: 2px;
      width: 10px;
      background-color: ${({ theme }) => theme.colors.neutral0};
      left: 50%;
      top: 50%;
      transform: translateX(-50%) translateY(-50%);
    }

    &:disabled {
      background-color: ${({ theme }) => theme.colors.neutral200};
      border: 1px solid ${({ theme }) => theme.colors.neutral300};
      &:after {
        background-color: ${({ theme }) => theme.colors.neutral500};
      }
    }
  }
`;
const BaseCheckbox = React__namespace.forwardRef(({ indeterminate = false, size = 'M', name, value = false, onValueChange, ...inputProps }, forwardedRef) => {
    const checkboxRef = React__namespace.useRef(null);
    const composedRefs = useComposeRefs.useComposedRefs(checkboxRef, forwardedRef);
    React__namespace.useEffect(() => {
        if (checkboxRef.current && indeterminate) {
            checkboxRef.current.indeterminate = indeterminate;
        }
        else {
            checkboxRef.current.indeterminate = false;
        }
    }, [indeterminate]);
    const handleValueChange = () => {
        if (onValueChange) {
            onValueChange(!value);
        }
    };
    return (jsxRuntime.jsx(Box.Box, { children: jsxRuntime.jsx(CheckboxInput, { size: size, checked: value, onChange: handleValueChange, type: "checkbox", ref: composedRefs, name: name, ...inputProps }) }));
});
BaseCheckbox.displayName = 'BaseCheckbox';

exports.BaseCheckbox = BaseCheckbox;
