'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const AccordionContext = require('./AccordionContext.js');
const Box = require('../Box/Box.js');

const AccordionContent = ({ children, ...props }) => {
    const { expanded, id } = AccordionContext.useAccordion();
    if (!expanded) {
        return null;
    }
    const idContent = `accordion-content-${id}`;
    const ariaLabelId = `accordion-label-${id}`;
    const ariaDescriptionId = `accordion-desc-${id}`;
    return (jsxRuntime.jsx(Box.Box, { role: "region", id: idContent, "aria-labelledby": ariaLabelId, "aria-describedby": ariaDescriptionId, ...props, children: children }));
};

exports.AccordionContent = AccordionContent;
