"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.eventHubEmit = exports.getService = exports.getSoftDeletedByAuth = void 0;
const utils_1 = require("@strapi/utils");
const utils_2 = require("../../utils");
const getSoftDeletedByAuth = (auth) => {
    var _a;
    const id = ((_a = auth.credentials) === null || _a === void 0 ? void 0 : _a.id) || null;
    const strategy = auth.strategy.name;
    return { id, strategy };
};
exports.getSoftDeletedByAuth = getSoftDeletedByAuth;
const getService = (name) => {
    return strapi.plugin(utils_2.plugin.pluginId).service(name);
};
exports.getService = getService;
const eventHubEmit = async (params) => {
    const modelDef = strapi.getModel(params.uid);
    const sanitizedEntity = await utils_1.sanitize.sanitizers.defaultSanitizeOutput(modelDef, params.entity);
    strapi.eventHub.emit(params.event, {
        model: modelDef.modelName,
        uid: params.uid,
        plugin: {
            id: utils_2.plugin.pluginId,
            action: params.action
        },
        entry: sanitizedEntity
    });
};
exports.eventHubEmit = eventHubEmit;
