"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const resend_1 = require("./resend");
const axios_mock_adapter_1 = __importDefault(require("axios-mock-adapter"));
const axios_1 = __importDefault(require("axios"));
const mock = new axios_mock_adapter_1.default(axios_1.default);
const resend = new resend_1.Resend('re_924b3rjh2387fbewf823');
describe('Resend', () => {
    afterEach(() => mock.resetHistory());
    it('throws API key error', () => {
        expect(() => new resend_1.Resend()).toThrowErrorMatchingSnapshot();
    });
    it('sends email', () => __awaiter(void 0, void 0, void 0, function* () {
        const payload = {
            from: 'bu@resend.com',
            to: 'zeno@resend.com',
            subject: 'Hello World',
        };
        mock.onPost('https://api.resend.com/email', payload).replyOnce(200, {
            id: '1234',
            from: 'bu@resend.com',
            to: 'zeno@resend.com',
            created_at: '123',
        });
        const data = yield resend.sendEmail(payload);
        expect(data).toMatchSnapshot();
    }));
    it('sends email with multiple recipients', () => __awaiter(void 0, void 0, void 0, function* () {
        const payload = {
            from: 'admin@resend.com',
            to: ['bu@resend.com', 'zeno@resend.com'],
            subject: 'Hello World',
        };
        mock.onPost('https://api.resend.com/email', payload).replyOnce(200, {
            id: '1234',
            from: 'admin@resend.com',
            to: ['bu@resend.com', 'zeno@resend.com'],
            created_at: '123',
        });
        const data = yield resend.sendEmail(payload);
        expect(data).toMatchSnapshot();
    }));
    it('sends email with multiple bcc recipients', () => __awaiter(void 0, void 0, void 0, function* () {
        const payload = {
            from: 'admin@resend.com',
            to: 'bu@resend.com',
            bcc: ['foo@resend.com', 'bar@resend.com'],
            subject: 'Hello World',
        };
        mock.onPost('https://api.resend.com/email', payload).replyOnce(200, {
            id: '1234',
            from: 'admin@resend.com',
            to: 'bu@resend.com',
            bcc: ['foo@resend.com', 'bar@resend.com'],
            created_at: '123',
        });
        const data = yield resend.sendEmail(payload);
        expect(data).toMatchSnapshot();
    }));
    it('sends email with multiple cc recipients', () => __awaiter(void 0, void 0, void 0, function* () {
        const payload = {
            from: 'admin@resend.com',
            to: 'bu@resend.com',
            cc: ['foo@resend.com', 'bar@resend.com'],
            subject: 'Hello World',
        };
        mock.onPost('https://api.resend.com/email', payload).replyOnce(200, {
            id: '1234',
            from: 'admin@resend.com',
            to: 'bu@resend.com',
            cc: ['foo@resend.com', 'bar@resend.com'],
            created_at: '123',
        });
        const data = yield resend.sendEmail(payload);
        expect(data).toMatchSnapshot();
    }));
    it('sends email with multiple replyTo emails', () => __awaiter(void 0, void 0, void 0, function* () {
        const apiPayload = {
            from: 'admin@resend.com',
            to: 'bu@resend.com',
            reply_to: ['foo@resend.com', 'bar@resend.com'],
            subject: 'Hello World',
        };
        mock.onPost('https://api.resend.com/email', apiPayload).replyOnce(200, {
            id: '1234',
            from: 'admin@resend.com',
            to: 'bu@resend.com',
            reply_to: ['foo@resend.com', 'bar@resend.com'],
            created_at: '123',
        });
        const payload = {
            from: 'admin@resend.com',
            to: 'bu@resend.com',
            reply_to: ['foo@resend.com', 'bar@resend.com'],
            subject: 'Hello World',
        };
        const data = yield resend.sendEmail(payload);
        expect(data).toMatchSnapshot();
    }));
});
