"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Resend = void 0;
const axios_1 = __importDefault(require("axios"));
const render_1 = require("@react-email/render");
const package_json_1 = require("../package.json");
class Resend {
    constructor(apiKey) {
        this.apiKey = apiKey;
        if (!apiKey) {
            this.apiKey = process.env.RESEND_API_KEY;
            if (!this.apiKey) {
                throw new Error('Missing API key. Pass it to the constructor `new Resend("re_123")`');
            }
        }
        this.apiKey = apiKey;
        this.baseUrl = process.env.RESEND_BASE_URL || 'https://api.resend.com';
        this.headers = {
            Authorization: `Bearer ${this.apiKey}`,
            'User-Agent': `node:${package_json_1.version}`,
            'Content-Type': 'application/json',
        };
        this.request = axios_1.default.create({
            baseURL: this.baseUrl,
            headers: this.headers,
            maxContentLength: Infinity,
            maxBodyLength: Infinity,
        });
        this.request.interceptors.response.use((response) => {
            return response;
        }, (error) => {
            var _a, _b, _c;
            if ((_b = (_a = error === null || error === void 0 ? void 0 : error.response) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.error) {
                return Promise.reject(error.response.data.error);
            }
            if ((_c = error === null || error === void 0 ? void 0 : error.response) === null || _c === void 0 ? void 0 : _c.data) {
                return Promise.reject(error.response.data);
            }
            return Promise.reject(error);
        });
    }
    sendEmail(data) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const path = `${this.baseUrl}/email`;
                if (data.react) {
                    data.html = (0, render_1.render)(data.react);
                    delete data.react;
                }
                const requestData = {
                    from: data.from,
                    to: data.to,
                    bcc: data.bcc,
                    cc: data.cc,
                    reply_to: data.reply_to,
                    subject: data.subject,
                    text: data.text,
                    html: data.html,
                    attachments: data.attachments,
                };
                const response = yield this.request(path, {
                    method: 'POST',
                    data: requestData,
                });
                return response.data;
            }
            catch (error) {
                throw error;
            }
        });
    }
}
exports.Resend = Resend;
