import { ResolvedIntlConfig } from './types';
import * as React from 'react';
import { FormatXMLElementFn } from 'intl-messageformat';
export declare function invariantIntlContext(intl?: any): asserts intl;
export declare const DEFAULT_INTL_CONFIG: Pick<ResolvedIntlConfig, 'fallbackOnEmptyString' | 'formats' | 'messages' | 'timeZone' | 'textComponent' | 'defaultLocale' | 'defaultFormats' | 'onError'>;
/**
 * Takes a `formatXMLElementFn`, and composes it in function, which passes
 * argument `parts` through, assigning unique key to each part, to prevent
 * "Each child in a list should have a unique "key"" React error.
 * @param formatXMLElementFn
 */
export declare function assignUniqueKeysToParts(formatXMLElementFn: FormatXMLElementFn<React.ReactNode>): FormatXMLElementFn<React.ReactNode>;
export declare function shallowEqual<T extends Record<string, unknown> = Record<string, unknown>>(objA?: T, objB?: T): boolean;
//# sourceMappingURL=utils.d.ts.map