/// <reference types="node" />

import {AgentOptions} from 'http'
import {IncomingHttpHeaders} from 'http'
import {IncomingMessage} from 'http'
import type {ProgressStream} from 'progress-stream'
import progressStream from 'progress-stream'
import type {UrlWithStringQuery} from 'url'

/**
 * Constructs a http.Agent and uses it for all requests.
 * This can be used to override settings such as `maxSockets`, `maxTotalSockets` (to limit concurrency) or change the `timeout`.
 * @public
 */
export declare function agent(opts?: AgentOptions): any

/** @public */
export declare type ApplyMiddleware = <T extends keyof MiddlewareHooks>(
  hook: T,
  value: MiddlewareHooks[T] extends (defaultValue: infer V, ...rest: any[]) => any ? V : never,
  ...args: MiddlewareHooks[T] extends (defaultValue: any, ...rest: infer P) => any ? P : never
) => ReturnType<MiddlewareHooks[T]>

/** @public */
export declare function base(baseUrl: string): {
  processOptions: (options: RequestOptions) => RequestOptions
}

/**
 * The cancel token API is based on the [cancelable promises proposal](https://github.com/tc39/proposal-cancelable-promises), which is currently at Stage 1.
 *
 * Code shamelessly stolen/borrowed from MIT-licensed [axios](https://github.com/mzabriskie/axios). Thanks to [Nick Uraltsev](https://github.com/nickuraltsev), [Matt Zabriskie](https://github.com/mzabriskie) and the other contributors of that project!
 */
/** @public */
export declare class Cancel {
  __CANCEL__: boolean
  message: string | undefined
  constructor(message: string | undefined)
  toString(): string
}

/** @public */
export declare class CancelToken {
  promise: Promise<any>
  reason?: Cancel
  constructor(executor: (cb: (message?: string) => void) => void)
  static source: () => {
    token: CancelToken
    cancel: (message?: string) => void
  }
}

/** @public */
declare function debug_2(opts?: any): {
  processOptions: (options: RequestOptions) => RequestOptions
  onRequest: (event: HookOnRequestEvent) => HookOnRequestEvent
  onResponse: (res: MiddlewareResponse, context: HttpContext) => MiddlewareResponse
  onError: (err: Error | null, context: HttpContext) => Error | null
}
export {debug_2 as debug}

/** @public */
export declare type DefineApplyMiddleware = (middleware: MiddlewareReducer) => ApplyMiddleware

/**
 * Reports the environment as either "node" or "browser", depending on what entry point was used to aid bundler debugging.
 * If 'browser' is used, then the globally available `fetch` class is used. While `node` will always use either `node:https` or `node:http` depending on the protocol.
 * @public
 */
export declare type ExportEnv = 'node' | 'react-server' | 'browser'

/** @public */
export declare interface FinalizeNodeOptionsPayload extends UrlWithStringQuery {
  method: RequestOptions['method']
  headers: RequestOptions['headers']
  maxRedirects: RequestOptions['maxRedirects']
  agent?: any
  cert?: any
  key?: any
  ca?: any
}

/** @public */
export declare function headers(
  _headers: any,
  opts?: any,
): {
  processOptions: (options: RequestOptions) => RequestOptions
}

/** @public */
export declare type HookOnRequestEvent = HookOnRequestEventNode | HookOnRequestEventBrowser

/** @public */
export declare interface HookOnRequestEventBase {
  options: RequestOptions
  context: HttpContext
  request: any
}

/** @public */
export declare interface HookOnRequestEventBrowser extends HookOnRequestEventBase {
  adapter: Omit<RequestAdapter, 'node'>
  progress?: undefined
}

/** @public */
export declare interface HookOnRequestEventNode extends HookOnRequestEventBase {
  adapter: 'node'
  progress: any
}

/** @public */
export declare interface HttpContext {
  options: RequestOptions
  channels: MiddlewareChannels
  applyMiddleware: ApplyMiddleware
}

/** @public */
export declare function httpErrors(): {
  onResponse: (res: MiddlewareResponse, ctx: HttpContext) => MiddlewareResponse
}

/**
 * request-node in node, browser-request in browsers
 * @public
 */
export declare type HttpRequest = (
  context: HttpContext,
  callback: (err: Error | null, response?: MiddlewareResponse) => void,
) => HttpRequestOngoing

/** @public */
export declare interface HttpRequestOngoing {
  abort: () => void
}

/** @public */
export declare function injectResponse(opts?: {
  inject: (
    event: Parameters<MiddlewareHooks['interceptRequest']>[1],
    prevValue: Parameters<MiddlewareHooks['interceptRequest']>[0],
  ) => Partial<MiddlewareResponse | undefined | void>
}): {
  interceptRequest: (
    prevValue: MiddlewareResponse | undefined,
    event: {
      adapter: RequestAdapter
      context: HttpContext
    },
  ) => MiddlewareResponse | undefined
}

/** @public */
export declare function jsonRequest(): {
  processOptions: (options: RequestOptions) => RequestOptions
}

/** @public */
export declare function jsonResponse(opts?: any): {
  onResponse: (response: MiddlewareResponse) => MiddlewareResponse
  processOptions: (options: RequestOptions) => RequestOptions & {
    headers: any
  }
}

/** @public */
export declare const keepAlive: (config?: any) => any

/** @public */
export declare type Middleware = Partial<MiddlewareHooks>

/** @public */
export declare interface MiddlewareChannels {
  request: PubSub<HttpContext>
  response: PubSub<unknown>
  progress: PubSub<unknown>
  error: PubSub<unknown>
  abort: PubSub<void>
}

/** @public */
export declare type MiddlewareHookName = keyof MiddlewareHooks

/** @public */
export declare interface MiddlewareHooks {
  processOptions: (options: RequestOptions) => RequestOptions
  validateOptions: (options: RequestOptions) => void | undefined
  interceptRequest: (
    prevValue: MiddlewareResponse | undefined,
    event: {
      adapter: RequestAdapter
      context: HttpContext
    },
  ) => MiddlewareResponse | undefined | void
  finalizeOptions: (
    options: FinalizeNodeOptionsPayload | RequestOptions,
  ) => FinalizeNodeOptionsPayload | RequestOptions
  onRequest: (evt: HookOnRequestEvent) => void
  onResponse: (response: MiddlewareResponse, context: HttpContext) => MiddlewareResponse
  onError: (err: Error | null, context: HttpContext) => any
  onReturn: (channels: MiddlewareChannels, context: HttpContext) => any
  onHeaders: (
    response: IncomingMessage,
    evt: {
      headers: IncomingHttpHeaders
      adapter: RequestAdapter
      context: HttpContext
    },
  ) => ProgressStream
}

/** @public */
export declare type MiddlewareReducer = {
  [T in keyof MiddlewareHooks]: ((
    ...args: Parameters<MiddlewareHooks[T]>
  ) => ReturnType<MiddlewareHooks[T]>)[]
}

/** @public */
export declare interface MiddlewareRequest {}

/** @public */
export declare interface MiddlewareResponse {
  body: any
  url: string
  method: string
  headers: any
  statusCode: number
  statusMessage: string
}

/** @public */
export declare type Middlewares = Middleware[]

/** @public */
export declare function mtls(config?: any): {
  finalizeOptions: (options: RequestOptions | FinalizeNodeOptionsPayload) =>
    | RequestOptions
    | (FinalizeNodeOptionsPayload & {
        cert: any
        key: any
        ca: any
      })
}

/** @public */
export declare function observable(opts?: {implementation?: any}): {
  onReturn: (channels: MiddlewareChannels, context: HttpContext) => any
}

/** @public */
export declare const processOptions: (opts: RequestOptions) => {
  url: string
  body?: any
  bodySize?: number | undefined
  cancelToken?: any
  compress?: boolean | undefined
  headers?: any
  maxRedirects?: number | undefined
  maxRetries?: number | undefined
  method?: string | undefined
  proxy?: any
  query?: any
  rawBody?: boolean | undefined
  shouldRetry?: any
  stream?: boolean | undefined
  timeout: any
  tunnel?: boolean | undefined
  debug?: any
  requestId?: number | undefined
  attemptNumber?: number | undefined
  withCredentials?: boolean | undefined
  fetch?: boolean | Omit<RequestInit, 'method'> | undefined
  useAbortSignal?: boolean | undefined
}

/** @public */
export declare function progress(): {
  onHeaders: (
    response: IncomingMessage,
    evt: {
      headers: IncomingHttpHeaders
      adapter: RequestAdapter
      context: HttpContext
    },
  ) => progressStream.ProgressStream
  onRequest: (evt: HookOnRequestEvent) => void
}

/** @public */
export declare const promise: {
  (options?: {onlyBody?: boolean; implementation?: PromiseConstructor}): {
    onReturn: (channels: MiddlewareChannels, context: HttpContext) => Promise<unknown>
  }
  Cancel: typeof Cancel
  CancelToken: typeof CancelToken
  isCancel: (value: any) => value is Cancel
}

/** @public */
export declare function proxy(_proxy: any): {
  processOptions: (options: RequestOptions) => {
    proxy: any
  } & RequestOptions
}

/** @public */
export declare interface PubSub<Message> {
  publish: (message: Message) => void
  subscribe: (subscriber: Subscriber<Message>) => () => void
}

/**
 * Reports the request adapter in use. `node` is only available if `ExportEnv` is also `node`.
 * When `ExportEnv` is `browser` then the adapter can be either `xhr` or `fetch`.
 * In the future `fetch` will be available in `node` as well.
 * @public
 */
export declare type RequestAdapter = 'node' | 'xhr' | 'fetch'

/** @public */
export declare type Requester = {
  use: (middleware: Middleware) => Requester
  clone: () => Requester
  (options: RequestOptions | string): any
}

/** @public */
export declare interface RequestOptions {
  url: string
  body?: any
  bodySize?: number
  cancelToken?: any
  compress?: boolean
  headers?: any
  maxRedirects?: number
  maxRetries?: number
  method?: string
  proxy?: any
  query?: any
  rawBody?: boolean
  shouldRetry?: any
  stream?: boolean
  timeout?: any
  tunnel?: boolean
  debug?: any
  requestId?: number
  attemptNumber?: number
  withCredentials?: boolean
  /**
   * Enables using the native `fetch` API instead of the default `http` module, and allows setting its options like `cache`
   */
  fetch?: boolean | Omit<RequestInit, 'method'>
  /**
   * Some frameworks have special behavior for `fetch` when an `AbortSignal` is used, and may want to disable it unless userland specifically opts-in.
   */
  useAbortSignal?: boolean
}

/** @public */
export declare const retry: {
  (opts?: Partial<RetryOptions>): {
    onError: (err: Error | null, context: HttpContext) => Error | null
  }
  shouldRetry: (err: any, num: number, options: any) => boolean
}

/** @public */
export declare interface RetryOptions {
  shouldRetry: (err: any, num: number, options: any) => boolean
  maxRetries?: number
  retryDelay?: (attemptNumber: number) => number
}

/** @public */
export declare interface Subscriber<Event> {
  (event: Event): void
}

/** @public */
export declare function urlEncoded(): {
  processOptions: (options: RequestOptions) => RequestOptions
}

/** @public */
export declare const validateOptions: (options: RequestOptions) => void

export {}
