import { createRequester } from './_chunks/createRequester-ryeXkh0z.js';
import parseHeaders from 'parse-headers';
var __accessCheck = (obj, member, msg) => {
  if (!member.has(obj)) throw TypeError("Cannot " + msg);
};
var __privateGet = (obj, member, getter) => {
  __accessCheck(obj, member, "read from private field");
  return getter ? getter.call(obj) : member.get(obj);
};
var __privateAdd = (obj, member, value) => {
  if (member.has(obj)) throw TypeError("Cannot add the same private member more than once");
  member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
};
var __privateSet = (obj, member, value, setter) => {
  __accessCheck(obj, member, "write to private field");
  setter ? setter.call(obj, value) : member.set(obj, value);
  return value;
};
var _method, _url, _resHeaders, _headers, _controller, _init, _useAbortSignal;
class FetchXhr {
  constructor() {
    /**
     * https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest/readyState
     */
    this.readyState = 0;
    this.responseType = "";
    /**
     * Private implementation details
     */
    __privateAdd(this, _method, void 0);
    __privateAdd(this, _url, void 0);
    __privateAdd(this, _resHeaders, void 0);
    __privateAdd(this, _headers, {});
    __privateAdd(this, _controller, void 0);
    __privateAdd(this, _init, {});
    __privateAdd(this, _useAbortSignal, void 0);
  }
  // eslint-disable-next-line @typescript-eslint/no-unused-vars -- _async is only declared for typings compatibility
  open(method, url, _async) {
    __privateSet(this, _method, method);
    __privateSet(this, _url, url);
    __privateSet(this, _resHeaders, "");
    this.readyState = 1;
    this.onreadystatechange();
    __privateSet(this, _controller, void 0);
  }
  abort() {
    if (__privateGet(this, _controller)) {
      __privateGet(this, _controller).abort();
    }
  }
  getAllResponseHeaders() {
    return __privateGet(this, _resHeaders);
  }
  setRequestHeader(name, value) {
    __privateGet(this, _headers)[name] = value;
  }
  // Allow setting extra fetch init options, needed for runtimes such as Vercel Edge to set `cache` and other options in React Server Components
  setInit(init) {
    let useAbortSignal = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    __privateSet(this, _init, init);
    __privateSet(this, _useAbortSignal, useAbortSignal);
  }
  send(body) {
    const textBody = this.responseType !== "arraybuffer";
    const options = {
      ...__privateGet(this, _init),
      method: __privateGet(this, _method),
      headers: __privateGet(this, _headers),
      body
    };
    if (typeof AbortController === "function" && __privateGet(this, _useAbortSignal)) {
      __privateSet(this, _controller, new AbortController());
      if (typeof EventTarget !== "undefined" && __privateGet(this, _controller).signal instanceof EventTarget) {
        options.signal = __privateGet(this, _controller).signal;
      }
    }
    if (typeof document !== "undefined") {
      options.credentials = this.withCredentials ? "include" : "omit";
    }
    fetch(__privateGet(this, _url), options).then(res => {
      res.headers.forEach((value, key) => {
        __privateSet(this, _resHeaders, __privateGet(this, _resHeaders) + "".concat(key, ": ").concat(value, "\r\n"));
      });
      this.status = res.status;
      this.statusText = res.statusText;
      this.readyState = 3;
      return textBody ? res.text() : res.arrayBuffer();
    }).then(resBody => {
      if (typeof resBody === "string") {
        this.responseText = resBody;
      } else {
        this.response = resBody;
      }
      this.readyState = 4;
      this.onreadystatechange();
    }).catch(err => {
      var _a;
      if (err.name === "AbortError") {
        this.onabort();
        return;
      }
      (_a = this.onerror) == null ? void 0 : _a.call(this, err);
    });
  }
}
_method = new WeakMap();
_url = new WeakMap();
_resHeaders = new WeakMap();
_headers = new WeakMap();
_controller = new WeakMap();
_init = new WeakMap();
_useAbortSignal = new WeakMap();
const adapter = typeof XMLHttpRequest === "function" ? "xhr" : "fetch";
const XmlHttpRequest = adapter === "xhr" ? XMLHttpRequest : FetchXhr;
const httpRequester = (context, callback) => {
  var _a;
  const opts = context.options;
  const options = context.applyMiddleware("finalizeOptions", opts);
  const timers = {};
  const injectedResponse = context.applyMiddleware("interceptRequest", void 0, {
    adapter,
    context
  });
  if (injectedResponse) {
    const cbTimer = setTimeout(callback, 0, null, injectedResponse);
    const cancel = () => clearTimeout(cbTimer);
    return {
      abort: cancel
    };
  }
  let xhr = new XmlHttpRequest();
  if (xhr instanceof FetchXhr && typeof options.fetch === "object") {
    xhr.setInit(options.fetch, (_a = options.useAbortSignal) != null ? _a : true);
  }
  const headers = options.headers;
  const delays = options.timeout;
  let aborted = false;
  let loaded = false;
  let timedOut = false;
  xhr.onerror = event => {
    onError(new Error("Request error while attempting to reach ".concat(options.url).concat(event.lengthComputable ? "(".concat(event.loaded, " of ").concat(event.total, " bytes transferred)") : "")));
  };
  xhr.ontimeout = event => {
    onError(new Error("Request timeout while attempting to reach ".concat(options.url).concat(event.lengthComputable ? "(".concat(event.loaded, " of ").concat(event.total, " bytes transferred)") : "")));
  };
  xhr.onabort = () => {
    stopTimers(true);
    aborted = true;
  };
  xhr.onreadystatechange = () => {
    resetTimers();
    if (aborted || xhr.readyState !== 4) {
      return;
    }
    if (xhr.status === 0) {
      return;
    }
    onLoad();
  };
  xhr.open(options.method, options.url, true
  // Always async
  );
  xhr.withCredentials = !!options.withCredentials;
  if (headers && xhr.setRequestHeader) {
    for (const key in headers) {
      if (headers.hasOwnProperty(key)) {
        xhr.setRequestHeader(key, headers[key]);
      }
    }
  }
  if (options.rawBody) {
    xhr.responseType = "arraybuffer";
  }
  context.applyMiddleware("onRequest", {
    options,
    adapter,
    request: xhr,
    context
  });
  xhr.send(options.body || null);
  if (delays) {
    timers.connect = setTimeout(() => timeoutRequest("ETIMEDOUT"), delays.connect);
  }
  return {
    abort
  };
  function abort() {
    aborted = true;
    if (xhr) {
      xhr.abort();
    }
  }
  function timeoutRequest(code) {
    timedOut = true;
    xhr.abort();
    const error = new Error(code === "ESOCKETTIMEDOUT" ? "Socket timed out on request to ".concat(options.url) : "Connection timed out on request to ".concat(options.url));
    error.code = code;
    context.channels.error.publish(error);
  }
  function resetTimers() {
    if (!delays) {
      return;
    }
    stopTimers();
    timers.socket = setTimeout(() => timeoutRequest("ESOCKETTIMEDOUT"), delays.socket);
  }
  function stopTimers(force) {
    if (force || aborted || xhr.readyState >= 2 && timers.connect) {
      clearTimeout(timers.connect);
    }
    if (timers.socket) {
      clearTimeout(timers.socket);
    }
  }
  function onError(error) {
    if (loaded) {
      return;
    }
    stopTimers(true);
    loaded = true;
    xhr = null;
    const err = error || new Error("Network error while attempting to reach ".concat(options.url));
    err.isNetworkError = true;
    err.request = options;
    callback(err);
  }
  function reduceResponse() {
    return {
      body: xhr.response || (xhr.responseType === "" || xhr.responseType === "text" ? xhr.responseText : ""),
      url: options.url,
      method: options.method,
      headers: parseHeaders(xhr.getAllResponseHeaders()),
      statusCode: xhr.status,
      statusMessage: xhr.statusText
    };
  }
  function onLoad() {
    if (aborted || loaded || timedOut) {
      return;
    }
    if (xhr.status === 0) {
      onError(new Error("Unknown XHR error"));
      return;
    }
    stopTimers();
    loaded = true;
    callback(null, reduceResponse());
  }
};
const getIt = function () {
  let initMiddleware = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  let httpRequest = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : httpRequester;
  return createRequester(initMiddleware, httpRequest);
};
const environment = "react-server";
export { adapter, environment, getIt };
//# sourceMappingURL=index.react-server.js.map
