import { jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Grid } from '../../Grid/Grid.mjs';

const subNavWidth = `${232 / 16}rem`;
const SubNavWrapper = styled(Grid) `
  width: ${subNavWidth};
  background: ${({ theme }) => theme.colors.neutral100};
  position: sticky;
  top: 0;
  height: 100vh;
  overflow-y: auto;
  border-right: 1px solid ${({ theme }) => theme.colors.neutral200};
  z-index: 1;
`;
const SubNav = ({ ariaLabel, ...props }) => {
    return jsx(SubNavWrapper, { "aria-label": ariaLabel, as: "nav", ...props });
};

export { SubNav, subNavWidth };
