import { jsxs, jsx } from 'react/jsx-runtime';
import { useRef, useState } from 'react';
import { Root, Trigger, Content, Item } from './Menu.mjs';
import * as Menu from './Menu.mjs';
export { Menu };
import { stripReactIdOfColon } from '../../helpers/strings.mjs';
import { useId } from '../../hooks/useId.mjs';
import { useIntersection } from '../../hooks/useIntersection.mjs';

const SimpleMenu = ({ children, onOpen, onClose, popoverPlacement, onReachEnd, ...props }) => {
    /**
     * Used for the intersection observer
     */
    const contentRef = useRef(null);
    const [internalIsOpen, setInternalIsOpen] = useState(false);
    const handleReachEnd = (entry) => {
        if (onReachEnd) {
            onReachEnd(entry);
        }
    };
    const handleOpenChange = (isOpen) => {
        if (isOpen && typeof onOpen === 'function') {
            onOpen();
        }
        else if (!isOpen && typeof onClose === 'function') {
            onClose();
        }
        setInternalIsOpen(isOpen);
    };
    const generatedId = useId();
    const intersectionId = `intersection-${stripReactIdOfColon(generatedId)}`;
    useIntersection(contentRef, handleReachEnd, {
        selectorToWatch: `#${intersectionId}`,
        /**
         * We need to know when the select is open because only then will viewportRef
         * not be null. Because it uses a portal that (sensibly) is not mounted 24/7.
         */
        skipWhen: !internalIsOpen,
    });
    return (jsxs(Root, { onOpenChange: handleOpenChange, children: [jsx(Trigger, { ...props, children: props.label }), jsx(Content, { intersectionId: intersectionId, popoverPlacement: popoverPlacement, children: children })] }));
};
const MenuItem = Item;

export { MenuItem, SimpleMenu };
