'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const PaginationContext = require('./PaginationContext.js');
const utils = require('../../themes/utils.js');
const BaseLink = require('../../BaseLink/BaseLink.js');
const VisuallyHidden = require('../../VisuallyHidden/VisuallyHidden.js');
const Typography = require('../../Typography/Typography.js');
const Box = require('../../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const transientProps = {
    active: true,
};
const LinkWrapper = styled__default.default(BaseLink.BaseLink).withConfig({
    shouldForwardProp: (prop, defPropValFN) => !transientProps[prop] && defPropValFN(prop),
}) `
  padding: ${({ theme }) => theme.spaces[3]};
  border-radius: ${({ theme }) => theme.borderRadius};
  box-shadow: ${({ active, theme }) => (active ? theme.shadows.filterShadow : undefined)};
  text-decoration: none;
  display: flex;

  ${utils.buttonFocusStyle}
`;
const PageLinkWrapper = styled__default.default(LinkWrapper) `
  color: ${({ theme, active }) => (active ? theme.colors.primary700 : theme.colors.neutral800)};
  background: ${({ theme, active }) => (active ? theme.colors.neutral0 : undefined)};

  &:hover {
    box-shadow: ${({ theme }) => theme.shadows.filterShadow};
  }
`;
const ActionLinkWrapper = styled__default.default(LinkWrapper) `
  font-size: ${11 / 16}rem;

  svg path {
    fill: ${(p) => (p['aria-disabled'] ? p.theme.colors.neutral300 : p.theme.colors.neutral600)};
  }

  &:focus,
  &:hover {
    svg path {
      fill: ${(p) => (p['aria-disabled'] ? p.theme.colors.neutral300 : p.theme.colors.neutral700)};
    }
  }

  ${(p) => p['aria-disabled']
    ? `
  pointer-events: none;
    `
    : undefined}
`;
const PreviousLink = React__default.default.forwardRef(({ children, ...props }, ref) => {
    const { activePage } = PaginationContext.usePagination();
    const disabled = activePage === 1;
    return (jsxRuntime.jsxs(ActionLinkWrapper, { ref: ref, "aria-disabled": disabled, tabIndex: disabled ? -1 : undefined, ...props, children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: children }), jsxRuntime.jsx(icons.ChevronLeft, { "aria-hidden": true })] }));
});
const NextLink = React__default.default.forwardRef(({ children, ...props }, ref) => {
    const { activePage, pageCount } = PaginationContext.usePagination();
    const disabled = activePage === pageCount;
    return (jsxRuntime.jsxs(ActionLinkWrapper, { ref: ref, "aria-disabled": disabled, tabIndex: disabled ? -1 : undefined, ...props, children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: children }), jsxRuntime.jsx(icons.ChevronRight, { "aria-hidden": true })] }));
});
const PageLink = React__default.default.forwardRef(({ number, children, ...props }, ref) => {
    const { activePage } = PaginationContext.usePagination();
    const isActive = activePage === number;
    return (jsxRuntime.jsxs(PageLinkWrapper, { ref: ref, ...props, active: isActive, children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: children }), jsxRuntime.jsx(Typography.Typography, { "aria-hidden": true, fontWeight: isActive ? 'bold' : undefined, lineHeight: "revert", variant: "pi", children: number })] }));
});
const Dots = ({ children, ...props }) => (jsxRuntime.jsxs(Box.Box, { ...props, children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: children }), jsxRuntime.jsx(Typography.Typography, { "aria-hidden": true, lineHeight: "revert", textColor: "neutral800", variant: "pi", children: "\u2026" })] }));

exports.Dots = Dots;
exports.NextLink = NextLink;
exports.PageLink = PageLink;
exports.PreviousLink = PreviousLink;
