import { jsxs, jsx } from 'react/jsx-runtime';
import { ChevronRight, ChevronLeft } from '@strapi/icons';
import styled from 'styled-components';
import { useMainNav } from './MainNavContext.mjs';
import { Flex } from '../../Flex/Flex.mjs';
import { Icon } from '../../Icon/Icon.mjs';
import { VisuallyHidden } from '../../VisuallyHidden/VisuallyHidden.mjs';

const NavCondenseWrapper = styled(Flex).attrs((props) => ({
    justifyContent: 'center',
    ...props,
})) `
  background: ${({ theme }) => theme.colors.neutral0};
  border: 1px solid ${({ theme }) => theme.colors.neutral150};
  border-radius: ${({ theme }) => theme.borderRadius};
  position: absolute;
  bottom: ${(9 + 4) / 16}rem; // 9 is the height of the svg and 4 is the padding below
  right: ${({ theme, condensed }) => (condensed ? 0 : theme.spaces[5])};
  transform: ${({ condensed }) => (condensed ? `translateX(50%)` : undefined)};
  z-index: 2;
  width: ${18 / 16}rem;
  height: ${25 / 16}rem;

  svg {
    width: ${6 / 16}rem;
    height: ${9 / 16}rem;
  }
`;
const NavCondense = ({ children, ...props }) => {
    const condensed = useMainNav();
    return (jsxs(NavCondenseWrapper, { as: "button", condensed: condensed, ...props, children: [jsx(Icon, { as: condensed ? ChevronRight : ChevronLeft, "aria-hidden": true, color: "neutral600" }), jsx(VisuallyHidden, { children: children })] }));
};

export { NavCondense };
