import React__default, { useState, useLayoutEffect } from 'react';

// Inspired by radix-ui useId hook https://github.com/radix-ui/primitives/blob/main/packages/react/id/src/id.tsx
// We `toString()` to prevent bundlers from trying to `import { useId } from 'react';`
const useReactId = React__default['useId'.toString()] || (() => undefined);
let count = 0;
const useId = (initialId) => {
    const [id, setId] = useState(useReactId());
    // React versions older than 18 will have client-side ids only.
    useLayoutEffect(() => {
        if (!initialId)
            setId((reactId) => reactId ?? String(count++));
    }, [initialId]);
    return initialId?.toString() ?? (id || '');
};

export { useId };
