'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const React = require('react');
const uiPrimitives = require('@strapi/ui-primitives');

function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
    if (e) {
        for (const k in e) {
            if (k !== 'default') {
                const d = Object.getOwnPropertyDescriptor(e, k);
                Object.defineProperty(n, k, d.get ? d : {
                    enumerable: true,
                    get: () => e[k]
                });
            }
        }
    }
    n.default = e;
    return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);

function useControllableState({ prop, defaultProp, onChange = () => { }, }) {
    const [uncontrolledProp, setUncontrolledProp] = useUncontrolledState({ defaultProp, onChange });
    const isControlled = prop !== undefined;
    const propValue = prop instanceof Function ? prop(uncontrolledProp) : prop;
    const value = isControlled ? propValue : uncontrolledProp;
    const handleChange = uiPrimitives.useCallbackRef(onChange);
    const setValue = React__namespace.useCallback((nextValue) => {
        if (isControlled) {
            const setter = nextValue;
            const value = typeof nextValue === 'function' ? setter(propValue) : nextValue;
            if (value !== propValue) {
                handleChange(value);
                setUncontrolledProp(nextValue);
            }
        }
        else {
            setUncontrolledProp(nextValue);
        }
    }, [isControlled, propValue, setUncontrolledProp, handleChange]);
    return [value, setValue];
}
function useUncontrolledState({ defaultProp, onChange }) {
    const uncontrolledState = React__namespace.useState(defaultProp);
    const [value] = uncontrolledState;
    const prevValueRef = React__namespace.useRef(value);
    const handleChange = uiPrimitives.useCallbackRef(onChange);
    React__namespace.useEffect(() => {
        if (prevValueRef.current !== value) {
            handleChange(value);
            prevValueRef.current = value;
        }
    }, [value, prevValueRef, handleChange]);
    return uncontrolledState;
}

exports.useControllableState = useControllableState;
