import { once, PREFIX } from './deprecations.mjs';
import { usePrevious as usePrevious$1 } from '../hooks/usePrevious.mjs';

const warnDeprecated = once(console.warn);
/**
 * @preserve
 * @deprecated usePrevious has moved. Please import it from "@strapi/design-system/hooks/usePrevious"
 */
const usePrevious = (...args) => {
    warnDeprecated(`${PREFIX} usePrevious has moved. Please import it from "@strapi/design-system/hooks/usePrevious"`);
    return usePrevious$1(...args);
};

export { usePrevious };
