'use strict';

const deprecations = require('./deprecations.js');
const useLockScroll$1 = require('../hooks/useLockScroll.js');

const warnDeprecated = deprecations.once(console.warn);
/**
 * @preserve
 * @deprecated useLockScroll has moved. Please import it from "@strapi/design-system/hooks/useLockScroll"
 */
const useLockScroll = (...args) => {
    warnDeprecated(`${deprecations.PREFIX} useLockScroll has moved. Please import it from "@strapi/design-system/hooks/useLockScroll"`);
    return useLockScroll$1(...args);
};

module.exports = useLockScroll;
