import { once, PREFIX } from './deprecations.mjs';
import { useIntersection as useIntersection$1 } from '../hooks/useIntersection.mjs';

const warnDeprecated = once(console.warn);
/**
 * @preserve
 * @deprecated useId has moved. Please import it from "@strapi/design-system/hooks/useId"
 */
const useIntersection = (...args) => {
    warnDeprecated(`${PREFIX} useIntersection has moved. Please import it from "@strapi/design-system/hooks/useIntersection"`);
    return useIntersection$1(...args);
};

export { useIntersection };
