'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const deprecations = require('./deprecations.js');
const useId$1 = require('../hooks/useId.js');

const warnDeprecated = deprecations.once(console.warn);
/**
 * @preserve
 * @deprecated useId has moved. Please import it from "@strapi/design-system/hooks/useId"
 */
const useId = (...args) => {
    warnDeprecated(`${deprecations.PREFIX} useId has moved. Please import it from "@strapi/design-system/hooks/useId"`);
    return useId$1.useId(...args);
};

exports.useId = useId;
