'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

function isKeyOf(o, s) {
    if (typeof o === 'string') {
        return false;
    }
    return s in o;
}
/**
 * @description Simple object check.
 * @export
 * @param item
 * @returns {boolean}
 */
function isObject(item) {
    return item && typeof item === 'object' && !Array.isArray(item);
}

exports.isKeyOf = isKeyOf;
exports.isObject = isObject;
