'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const constants = require('./constants.js');

const ellipsisStyle = ({ ellipsis = false }) => ellipsis &&
    `
    display: block;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
  `;
const variantStyle = ({ variant = constants.OMEGA, theme, }) => {
    switch (variant) {
        case constants.ALPHA: {
            return `
        font-weight: ${theme.fontWeights.bold};
        font-size: ${theme.fontSizes[5]};
        line-height: ${theme.lineHeights[2]};
      `;
        }
        case constants.BETA: {
            return `
        font-weight: ${theme.fontWeights.bold};
        font-size: ${theme.fontSizes[4]};
        line-height: ${theme.lineHeights[1]};
      `;
        }
        case constants.DELTA: {
            return `
        font-weight: ${theme.fontWeights.semiBold};
        font-size: ${theme.fontSizes[3]};
        line-height: ${theme.lineHeights[2]};
      `;
        }
        case constants.EPSILON: {
            return `
        font-size: ${theme.fontSizes[3]};
        line-height: ${theme.lineHeights[6]};
      `;
        }
        case constants.OMEGA: {
            return `
        font-size: ${theme.fontSizes[2]};
        line-height: ${theme.lineHeights[4]};
      `;
        }
        case constants.PI: {
            return `
        font-size: ${theme.fontSizes[1]};
        line-height: ${theme.lineHeights[3]};
      `;
        }
        case constants.SIGMA: {
            return `
        font-weight: ${theme.fontWeights.bold};
        font-size: ${theme.fontSizes[0]};
        line-height: ${theme.lineHeights[5]};
        text-transform: uppercase;
      `;
        }
        default: {
            return `
        font-size: ${theme.fontSizes[2]};
      `;
        }
    }
};

exports.ellipsisStyle = ellipsisStyle;
exports.variantStyle = variantStyle;
