'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const React = require('react');

const useTooltipHandlers = (delay) => {
    const [visible, setVisible] = React.useState(false);
    const timerRef = React.useRef(null);
    const clearTimer = () => {
        if (typeof timerRef.current === 'number') {
            clearTimeout(timerRef.current);
            timerRef.current = null;
        }
    };
    React.useEffect(() => {
        return () => {
            clearTimer();
        };
    }, []);
    const onFocus = () => {
        setVisible(true);
    };
    const onBlur = () => {
        setVisible(false);
    };
    const onMouseEnter = () => {
        timerRef.current = setTimeout(() => {
            setVisible(true);
        }, delay);
    };
    const onMouseLeave = () => {
        clearTimer();
        setVisible(false);
    };
    return { visible, onFocus, onBlur, onMouseEnter, onMouseLeave };
};

exports.useTooltipHandlers = useTooltipHandlers;
