import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import * as React from 'react';
import styled from 'styled-components';
import { useTooltipHandlers } from './hooks/useTooltipHandlers.mjs';
import { useTooltipLayout } from './hooks/useTooltipLayout.mjs';
import { useId } from '../hooks/useId.mjs';
import { Portal } from '../Portal/Portal.mjs';
import { Box } from '../Box/Box.mjs';
import { VisuallyHidden } from '../VisuallyHidden/VisuallyHidden.mjs';
import { Typography } from '../Typography/Typography.mjs';

const TooltipWrapper = styled(Box) `
  /* z-index exist because of its position inside Modals */
  z-index: 4;
  display: ${({ visible }) => (visible ? 'revert' : 'none')};
`;
const Tooltip = ({ children, label, description, delay = 500, position = 'top', id, ...props }) => {
    const tooltipId = useId(id);
    const descriptionId = useId();
    const { visible, ...tooltipHandlers } = useTooltipHandlers(delay);
    const { tooltipWrapperRef, toggleSourceRef } = useTooltipLayout(visible, position);
    const childrenClone = React.cloneElement(children, {
        tabIndex: 0,
        'aria-labelledby': label ? tooltipId : undefined,
        'aria-describedby': description ? tooltipId : undefined,
        ...tooltipHandlers,
    });
    return (jsxs(Fragment, { children: [jsx(Portal, { children: jsxs(TooltipWrapper, { id: tooltipId, background: "neutral900", hasRadius: true, padding: 2, role: "tooltip", ref: tooltipWrapperRef, visible: visible, position: "absolute", ...props, children: [visible && jsx(VisuallyHidden, { id: descriptionId, children: description }), jsx(Typography, { as: "p", variant: "pi", fontWeight: "bold", textColor: "neutral0", children: label || description })] }) }), jsx("span", { ref: toggleSourceRef, children: childrenClone })] }));
};

export { Tooltip };
