import { jsxs, jsx } from 'react/jsx-runtime';
import * as React from 'react';
import styled from 'styled-components';
import { useControllableState } from '../hooks/useControllableState.mjs';
import { useId } from '../hooks/useId.mjs';
import { useField } from '../Field/FieldContext.mjs';
import { Typography } from '../Typography/Typography.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { inputFocusStyle } from '../themes/utils.mjs';
import { Field } from '../Field/Field.mjs';
import { FieldLabel } from '../Field/FieldLabel.mjs';
import { FieldHint } from '../Field/FieldHint.mjs';
import { FieldError } from '../Field/FieldError.mjs';
import { TextButton } from '../TextButton/TextButton.mjs';

/**
 * TODO: This should probably follow the switch button pattern
 * as seen – https://www.w3.org/WAI/ARIA/apg/patterns/switch/examples/switch-button/
 */
const ToggleInputInput = React.forwardRef(({ offLabel, onLabel, disabled, checked: checkedProp, onChange, size = 'M', ...props }, forwardedRef) => {
    const [checked = false, setChecked] = useControllableState({
        prop: checkedProp,
    });
    const { error, id, name, required } = useField();
    const isFalseyChecked = checked !== null && !checked;
    const hintId = `${id}-hint`;
    const errorId = `${id}-error`;
    return (jsxs(ToggleWrapper, { position: "relative", hasRadius: true, padding: 1, background: disabled ? 'neutral150' : 'neutral100', borderStyle: "solid", borderWidth: "1px", borderColor: "neutral200", wrap: "wrap", cursor: disabled ? 'not-allowed' : 'pointer', hasError: Boolean(error), children: [jsx(ToggleOption, { hasRadius: true, flex: "1 1 50%", paddingTop: 2, paddingBottom: 2, paddingLeft: 3, paddingRight: 3, justifyContent: "center", background: disabled && isFalseyChecked ? 'neutral200' : isFalseyChecked ? 'neutral0' : 'transparent', borderColor: disabled && isFalseyChecked
                    ? 'neutral300'
                    : isFalseyChecked
                        ? 'neutral200'
                        : disabled
                            ? 'neutral150'
                            : 'neutral100', size: size, children: jsx(Typography, { variant: "pi", fontWeight: "bold", textTransform: "uppercase", textColor: disabled ? 'neutral700' : isFalseyChecked ? 'danger700' : 'neutral600', children: offLabel }) }), jsx(ToggleOption, { hasRadius: true, flex: "1 1 50%", paddingLeft: 3, paddingRight: 3, justifyContent: "center", background: disabled && checked ? 'neutral200' : checked ? 'neutral0' : 'transparent', borderColor: disabled && checked ? 'neutral300' : checked ? 'neutral200' : disabled ? 'neutral150' : 'neutral100', size: size, children: jsx(Typography, { variant: "pi", fontWeight: "bold", textTransform: "uppercase", textColor: disabled ? 'neutral700' : checked ? 'primary600' : 'neutral600', children: onLabel }) }), jsx(Input, { ...props, ref: forwardedRef, onChange: (e) => {
                    setChecked(e.currentTarget.checked);
                    onChange?.(e);
                }, type: "checkbox", id: id, name: name, "aria-required": required, disabled: disabled, "aria-disabled": disabled, "aria-describedby": id ? `${hintId} ${errorId}` : undefined, checked: Boolean(checked) })] }));
});
const ToggleWrapper = styled(Flex) `
  ${inputFocusStyle()}
`;
const ToggleOption = styled(Flex) `
  /**
    We declare the defined value because we want the height of the input when 
    the values are in a row to be 40px. But defining a height on the label
    would break the input when it wraps.
  */
  padding-top: ${({ size }) => `${size === 'S' ? '2px' : '6px'}`};
  padding-bottom: ${({ size }) => `${size === 'S' ? '2px' : '6px'}`};
`;
const Input = styled.input `
  height: 100%;
  left: 0;
  opacity: 0;
  position: absolute;
  top: 0;
  z-index: 0;
  width: 100%;
`;
const ToggleInput = React.forwardRef(({ disabled = false, error, hint, label, name, labelAction, required = false, id, onClear, clearLabel, checked, ...props }, forwardedRef) => {
    const generatedId = useId(id);
    return (jsx(Field, { name: name, hint: hint, error: error, id: generatedId, required: required, maxWidth: "320px", children: jsxs(Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [jsxs(Flex, { children: [label ? jsx(FieldLabel, { action: labelAction, children: label }) : null, clearLabel && onClear && checked !== null && !disabled && (jsx(ClearButton, { onClick: onClear, children: clearLabel }))] }), jsx(ToggleInputInput, { ref: forwardedRef, checked: checked, disabled: disabled, ...props }), jsx(FieldHint, {}), jsx(FieldError, {})] }) }));
});
const ClearButton = styled(TextButton) `
  align-self: flex-end;
  margin-left: auto;
`;

export { ToggleInput };
