import { jsx, jsxs } from 'react/jsx-runtime';
import * as React from 'react';
import { Clock } from '@strapi/icons';
import styled from 'styled-components';
import { ComboboxInput, Option } from '../Combobox/Combobox.mjs';
import { useDesignSystem } from '../DesignSystemProvider.mjs';
import { useControllableState } from '../hooks/useControllableState.mjs';
import { useDateFormatter } from '../hooks/useDateFormatter.mjs';
import { useId } from '../hooks/useId.mjs';
import { Field } from '../Field/Field.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { FieldLabel } from '../Field/FieldLabel.mjs';
import { FieldHint } from '../Field/FieldHint.mjs';
import { FieldError } from '../Field/FieldError.mjs';

const isNotAlphabeticalCharacter = (str) => {
    return Boolean(str.match(/^[^a-zA-Z]*$/));
};
const TimePickerInput = React.forwardRef(({ id, step = 15, 
/**
 * @preserve
 * @deprecated This is no longer used.
 */
ariaLabel: _ariaLabel, 
/**
 * @preserve
 * @deprecated This is no longer used.
 */
selectButtonTitle: _selectButtonTitle, value: valueProp, defaultValue, onChange, ...restProps }, forwardedRef) => {
    const context = useDesignSystem('TimePicker');
    const generatedId = useId(id);
    const [textValue, setTextValue] = React.useState('');
    const [value, setValue] = useControllableState({
        prop: valueProp,
        defaultProp: defaultValue,
        onChange,
    });
    const formatter = useDateFormatter(context.locale, {
        hour: '2-digit',
        minute: '2-digit',
        hour12: false,
    });
    const separator = React.useMemo(() => {
        const parts = formatter.formatToParts(new Date());
        const { value: separator } = parts.find((part) => part.type === 'literal');
        return separator;
    }, [formatter]);
    const timeOptions = React.useMemo(() => {
        const stepCount = 60 / step;
        return [...Array(24).keys()].flatMap((hour) => [...Array(stepCount).keys()].map((minuteStep) => formatter.format(new Date(0, 0, 0, hour, minuteStep * step))));
    }, [step, formatter]);
    const handleTextValueChange = (string) => {
        if (!string || isNotAlphabeticalCharacter(string)) {
            setTextValue(string);
        }
    };
    const createNewTimeValue = (value) => {
        const [hours, minutes] = value.split(separator);
        if (!hours && !minutes)
            return undefined;
        const hoursAsNumber = Number(hours ?? '0');
        const minutesAsNumber = Number(minutes ?? '0');
        if (hoursAsNumber > 23 || minutesAsNumber > 59)
            return undefined;
        return formatter.format(new Date(0, 0, 0, hoursAsNumber, minutesAsNumber));
    };
    const handleBlur = (event) => {
        const newValue = createNewTimeValue(event.target.value);
        if (newValue) {
            setTextValue(newValue);
            setValue(newValue);
        }
        else {
            setTextValue(value);
        }
    };
    const handleChange = (changedValue) => {
        if (typeof changedValue !== 'undefined') {
            const newValue = createNewTimeValue(changedValue);
            setValue(newValue);
        }
        else {
            setValue(changedValue);
        }
    };
    /**
     * Because we allow values that aren't necessarily in the list & we control the text value, we need to
     * update the text value when the value changes to keep the two in sync.
     */
    React.useEffect(() => {
        const actualValue = typeof valueProp === 'undefined' ? '' : valueProp;
        if (isNotAlphabeticalCharacter(actualValue)) {
            setTextValue(actualValue);
        }
    }, [valueProp, setTextValue]);
    return (jsx(ComboboxInput, { ...restProps, ref: forwardedRef, value: value, onChange: handleChange, isPrintableCharacter: isNotAlphabeticalCharacter, allowCustomValue: true, placeholder: `--${separator}--`, autocomplete: "none", startIcon: jsx(StyledClock, {}), id: generatedId, inputMode: "numeric", pattern: `\\d{2}\\${separator}\\d{2}`, textValue: textValue, onTextValueChange: handleTextValueChange, onBlur: handleBlur, children: timeOptions.map((time) => (jsx(Option, { value: time, children: time }, time))) }));
});
const StyledClock = styled(Clock) `
  height: 1rem;
  width: 1rem;

  & > path {
    fill: ${({ theme }) => theme.colors.neutral500};
  }
`;
const TimePicker = React.forwardRef(({ label, error, hint, id, required, labelAction, ...restProps }, forwardedRef) => {
    const generatedId = useId(id);
    return (jsx(Field, { hint: hint, error: error, id: generatedId, required: required, children: jsxs(Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [jsx(FieldLabel, { action: labelAction, children: label }), jsx(TimePickerInput, { ref: forwardedRef, id: generatedId, error: error, required: required, ...restProps }), jsx(FieldHint, {}), jsx(FieldError, {})] }) }));
});

export { TimePicker, TimePickerInput };
