'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const useId = require('../hooks/useId.js');
const utils = require('../themes/utils.js');
const Box = require('../Box/Box.js');
const FieldContext = require('../Field/FieldContext.js');
const Field = require('../Field/Field.js');
const Flex = require('../Flex/Flex.js');
const FieldLabel = require('../Field/FieldLabel.js');
const FieldHint = require('../Field/FieldHint.js');
const FieldError = require('../Field/FieldError.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const Wrapper = styled__default.default(Box.Box) `
  ${utils.inputFocusStyle()}
`;
const TextareaElement = styled__default.default(Box.Box) `
  border: none;
  resize: none;

  ::placeholder {
    color: ${({ theme }) => theme.colors.neutral500};
    font-size: ${({ theme }) => theme.fontSizes[2]};
    color: ${({ theme }) => theme.colors.neutral500};
    opacity: 1;
  }

  &:focus-within {
    outline: none;
  }
`;
const TextareaInput = React__default.default.forwardRef(({ disabled, ...props }, ref) => {
    const { id, error, hint, required } = FieldContext.useField();
    const hasError = Boolean(error);
    let ariaDescription = hint ? `${id}-hint` : undefined;
    if (error) {
        ariaDescription = `${id}-error`;
    }
    return (jsxRuntime.jsx(Wrapper, { borderColor: hasError ? 'danger600' : 'neutral200', hasError: hasError, hasRadius: true, children: jsxRuntime.jsx(TextareaElement, { "aria-describedby": ariaDescription, "aria-invalid": hasError, "aria-required": required, as: "textarea", background: disabled ? 'neutral150' : 'neutral0', color: disabled ? 'neutral600' : 'neutral800', disabled: disabled, fontSize: 2, hasRadius: true, height: `${105 / 16}rem`, id: id, ref: ref, lineHeight: 4, padding: 4, width: "100%", ...props }) }));
});
const Textarea = React__default.default.forwardRef(({ name, hint, error, label, labelAction, id, required = false, children, value, ...props }, ref) => {
    const generatedId = useId.useId(id);
    return (jsxRuntime.jsx(Field.Field, { name: name, hint: hint, error: error, id: generatedId, required: required, children: jsxRuntime.jsxs(Flex.Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [label && jsxRuntime.jsx(FieldLabel.FieldLabel, { action: labelAction, children: label }), jsxRuntime.jsx(TextareaInput, { ref: ref, value: children ?? value, ...props }), jsxRuntime.jsx(FieldHint.FieldHint, {}), jsxRuntime.jsx(FieldError.FieldError, {})] }) }));
});

exports.Textarea = Textarea;
