'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const Flex = require('../Flex/Flex.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const Tag = ({ children, icon, disabled = false, onClick, ...props }) => {
    const handleClick = (e) => {
        if (disabled || !onClick)
            return;
        onClick(e);
    };
    return (jsxRuntime.jsxs(TagWrapper, { as: "button", background: disabled ? 'neutral200' : 'primary100', color: disabled ? 'neutral700' : 'primary600', paddingLeft: 3, paddingRight: 3, onClick: handleClick, "aria-disabled": disabled, disabled: disabled, borderWidth: "1px", borderStyle: "solid", borderColor: disabled ? 'neutral300' : 'primary200', hasRadius: true, height: `${32 / 16}rem`, gap: 2, ...props, children: [jsxRuntime.jsx(TagText, { "$disabled": disabled, variant: "pi", fontWeight: "bold", as: "span", children: children }), icon] }));
};
const TagWrapper = styled__default.default(Flex.Flex) `
  & > svg {
    height: ${8 / 16}rem;
    width: ${8 / 16}rem;
  }

  & > svg path {
    fill: ${({ theme, ...p }) => (p['aria-disabled'] ? theme.colors.neutral600 : theme.colors.primary600)};
  }
`;
const TagText = styled__default.default(Typography.Typography) `
  color: inherit;
  border-right: 1px solid ${({ theme, $disabled }) => ($disabled ? theme.colors.neutral300 : theme.colors.primary200)};
  padding-right: ${({ theme }) => theme.spaces[2]};
`;

exports.Tag = Tag;
