'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const styled = require('styled-components');
const Box = require('../Box/Box.js');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

/** Simple variant */
const SimpleTabBox = styled__default.default(Box.Box) `
  border-bottom: 2px solid
    ${({ theme, selected, hasError }) => {
    if (selected) {
        if (hasError) {
            return theme.colors.danger600;
        }
        return theme.colors.primary600;
    }
    return 'transparent';
}};
`;
/** Default variant */
const DefaultTabBox = styled__default.default(Box.Box) `
  border-bottom: 1px solid ${({ theme, selected }) => (selected ? theme.colors.neutral0 : theme.colors.neutral150)};
`;
const DefaultTabButton = styled__default.default.button `
  border: none;
  background: transparent;
  padding: 0;

  & + & > ${DefaultTabBox} {
    border-left: 1px solid ${({ theme }) => theme.colors.neutral150};
  }

  ${DefaultTabBox} {
    border-right: ${({ theme, showRightBorder }) => showRightBorder ? `1px solid ${theme.colors.neutral150}` : 'none'};
  }

  // Hack preventing the outline from being overflow by the following tab
  outline-offset: -2px;

  &[aria-disabled='true'] {
    cursor: not-allowed;
  }
`;
const DefaultTabsRow = styled__default.default(Flex.Flex) `
  & > * {
    flex: 1;
  }

  & ${DefaultTabButton}:first-of-type ${DefaultTabBox} {
    border-radius: ${({ theme }) => `${theme.borderRadius} 0 0 0`};
  }

  & ${DefaultTabButton}:last-of-type ${DefaultTabBox} {
    border-radius: ${({ theme }) => `0 ${theme.borderRadius} 0 0`};
  }

  & ${DefaultTabButton}[aria-selected="true"] ${DefaultTabBox} {
    border-radius: ${({ theme }) => `${theme.borderRadius} ${theme.borderRadius} 0 0`};
    border-left: none;
    border-right: none;
  }
`;

exports.DefaultTabBox = DefaultTabBox;
exports.DefaultTabButton = DefaultTabButton;
exports.DefaultTabsRow = DefaultTabsRow;
exports.SimpleTabBox = SimpleTabBox;
