'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const TabsContext = require('./TabsContext.js');

const TabPanels = ({ children, ...props }) => {
    const { id, selectedTabIndex } = TabsContext.useTabs();
    const childrenArray = React.Children.toArray(children)
        .map((node, index) => React.cloneElement(node, { id: `${id}-${index}` }))
        .filter((_, index) => index === selectedTabIndex);
    return jsxRuntime.jsx("div", { ...props, children: childrenArray });
};
const TabPanel = ({ id, ...props }) => {
    const tabId = `${id}-tab`;
    const tabPanelId = `${id}-tabpanel`;
    return jsxRuntime.jsx("div", { id: tabPanelId, role: "tabpanel", tabIndex: 0, "aria-labelledby": tabId, ...props });
};

exports.TabPanel = TabPanel;
exports.TabPanels = TabPanels;
