'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const RawTr = require('../RawTable/RawTr.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const TrWrapper = styled__default.default(RawTr.RawTr) `
  border-bottom: 1px solid ${({ theme }) => theme.colors.neutral150};

  & td,
  & th {
    padding: ${({ theme }) => theme.spaces[4]};
  }

  & td:first-of-type,
  & th:first-of-type {
    padding: 0 ${({ theme }) => theme.spaces[1]};
  }

  // Resetting padding values and fixing a height
  th {
    padding-top: 0;
    padding-bottom: 0;
    height: ${56 / 16}rem;
  }
`;
const Tr = (props) => {
    return jsxRuntime.jsx(TrWrapper, { ...props });
};

exports.Tr = Tr;
