import { jsxs, jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Box } from '../Box/Box.mjs';
import { Divider } from '../Divider/Divider.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Typography } from '../Typography/Typography.mjs';

const IconBox = styled(Box) `
  height: ${24 / 16}rem;
  width: ${24 / 16}rem;
  border-radius: 50%;
  display: flex;
  justify-content: center;
  align-items: center;

  svg {
    height: ${10 / 16}rem;
    width: ${10 / 16}rem;
  }

  svg path {
    fill: ${({ theme }) => theme.colors.primary600};
  }
`;
// TODO: remove when the reset css button is merged
const ButtonBox = styled(Box) `
  border-radius: 0 0 ${({ theme }) => theme.borderRadius} ${({ theme }) => theme.borderRadius};
  display: block;
  width: 100%;
  border: none;
`;
const TFooter = ({ children, icon, ...props }) => {
    return (jsxs("div", { children: [jsx(Divider, {}), jsx(ButtonBox, { as: "button", background: "primary100", padding: 5, ...props, children: jsxs(Flex, { children: [jsx(IconBox, { "aria-hidden": true, background: "primary200", children: icon }), jsx(Box, { paddingLeft: 3, children: jsx(Typography, { variant: "pi", fontWeight: "bold", textColor: "primary600", children: children }) })] }) })] }));
};

export { TFooter };
