import { jsx } from 'react/jsx-runtime';
import React__default from 'react';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';

const SubNavSections = ({ children, spacing = 2, horizontal = false, ...props }) => {
    return (jsx(Box, { paddingTop: 2, paddingBottom: 4, children: jsx(Flex, { as: "ol", gap: spacing, direction: horizontal ? 'row' : 'column', alignItems: horizontal ? 'center' : 'stretch', ...props, children: React__default.Children.map(children, (child, index) => {
                // eslint-disable-next-line react/no-array-index-key
                return jsx("li", { children: child }, index);
            }) }) }));
};

export { SubNavSections };
