import { jsxs, jsx } from 'react/jsx-runtime';
import { CarretDown } from '@strapi/icons';
import styled from 'styled-components';
import { Flex } from '../Flex/Flex.mjs';
import { Box } from '../Box/Box.mjs';
import { Typography } from '../Typography/Typography.mjs';

// TODO: these could be props
const SubNavSectionLabelWrapper = styled(Flex) `
  border: none;
  padding: 0;
  background: transparent;
`;
// TODO: these could be props
const DropDownIconWrapper = styled.div `
  display: flex;
  align-items: center;
  transform: rotateX(${({ rotated }) => (rotated ? '0deg' : '180deg')});
`;
const SubNavSectionLabel = ({ collapsable = false, label, onClick = () => { }, ariaExpanded, ariaControls, }) => {
    if (collapsable) {
        return (jsxs(SubNavSectionLabelWrapper, { as: "button", onClick: onClick, "aria-expanded": ariaExpanded, "aria-controls": ariaControls, textAlign: "left", children: [jsx(Box, { paddingRight: 1, children: jsx(Typography, { variant: "sigma", textColor: "neutral600", children: label }) }), collapsable && (jsx(DropDownIconWrapper, { rotated: ariaExpanded, children: jsx(CarretDown, { "aria-hidden": true }) }))] }));
    }
    return (jsx(SubNavSectionLabelWrapper, { children: jsx(Box, { paddingRight: 1, children: jsx(Typography, { variant: "sigma", textColor: "neutral600", children: label }) }) }));
};

export { SubNavSectionLabel };
