import { jsxs, jsx } from 'react/jsx-runtime';
import React__default from 'react';
import styled from 'styled-components';
import { SubNavSectionLabel } from './SubNavSectionLabel.mjs';
import { useId } from '../hooks/useId.mjs';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Badge } from '../Badge/Badge.mjs';

const SubNavSectionWrapper = styled(Box) `
  svg {
    height: ${4 / 16}rem;
    path {
      fill: ${({ theme }) => theme.colors.neutral500};
    }
  }
`;
const SubNavSection = ({ collapsable = false, label, badgeLabel, children, id }) => {
    const [isOpen, setOpenLinks] = React__default.useState(true);
    const listId = useId(id);
    const handleClick = () => {
        setOpenLinks((prev) => !prev);
    };
    return (jsxs(Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [jsx(SubNavSectionWrapper, { paddingLeft: 6, paddingTop: 1, paddingBottom: 1, paddingRight: 4, children: jsxs(Box, { position: "relative", paddingRight: badgeLabel ? 6 : 0, children: [jsx(SubNavSectionLabel, { onClick: handleClick, ariaExpanded: isOpen, ariaControls: listId, collapsable: collapsable, label: label }), badgeLabel && (jsx(Badge, { backgroundColor: "neutral150", textColor: "neutral600", position: "absolute", right: 0, top: "50%", transform: "translateY(-50%)", children: badgeLabel }))] }) }), (!collapsable || isOpen) && (jsx("ol", { id: listId, children: React__default.Children.map(children, (child, index) => {
                    // eslint-disable-next-line react/no-array-index-key
                    return jsx("li", { children: child }, index);
                }) }))] }));
};

export { SubNavSection };
