import { jsx } from 'react/jsx-runtime';
import { forwardRef } from 'react';
import styled from 'styled-components';
import { extractStyleFromTheme } from '../helpers/theme.mjs';
import { Flex } from '../Flex/Flex.mjs';

/**
 * Prevents these attributes from being spread on the DOM node
 */
const transientProps = {
    size: true,
    spacing: true,
};
const StackV = styled(Flex).withConfig({
    shouldForwardProp: (prop, defPropValFN) => !transientProps[prop] && defPropValFN(prop),
}) `
  & > * {
    margin-top: 0;
    margin-bottom: 0;
  }

  & > * + * {
    margin-top: ${({ theme, spacing }) => extractStyleFromTheme(theme.spaces, spacing, undefined)};
  }
`;
const StackH = styled(Flex).withConfig({
    shouldForwardProp: (prop, defPropValFN) => !transientProps[prop] && defPropValFN(prop),
}) `
  & > * {
    margin-left: 0;
    margin-right: 0;
  }

  & > * + * {
    margin-left: ${({ theme, spacing }) => extractStyleFromTheme(theme.spaces, spacing, undefined)};
  }
`;
const Stack = forwardRef(({ horizontal = false, spacing, size, ...props }, ref) => {
    if (size) {
        console.warn('Deprecation warning: Usage of "size" prop in Stack component is deprecated. This is discouraged and will be removed in the next major release. Please use "spacing" instead');
    }
    if (horizontal) {
        return jsx(StackH, { ref: ref, spacing: spacing || size, ...props });
    }
    return jsx(StackV, { direction: "column", alignItems: "stretch", ref: ref, spacing: spacing || size, ...props });
});
Stack.displayName = 'Stack';

export { Stack };
