'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const icons = require('@strapi/icons');
const uiPrimitives = require('@strapi/ui-primitives');
const reactRouterDom = require('react-router-dom');
const styled = require('styled-components');
const utils = require('./utils.js');
const keyboardKeys = require('../helpers/keyboardKeys.js');
const useId = require('../hooks/useId.js');
const Link = require('../Link/Link.js');
const Button = require('../Button/Button.js');
const Popover = require('../Popover/Popover.js');
const Box = require('../Box/Box.js');
const Typography = require('../Typography/Typography.js');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const OptionButton = styled__default.default.button `
  border: none;
  padding: 0;
  background: transparent;
  cursor: pointer;
  ${utils.getOptionStyle}
`;
const OptionLink = styled__default.default(reactRouterDom.NavLink) `
  text-decoration: none;
  ${utils.getOptionStyle}
`;
const OptionExternalLink = styled__default.default(Link.Link) `
  /* Removing Link hover effect */
  &:hover {
    color: currentColor;
  }

  &:focus-visible {
    /* Removing Link focus-visible after properties and reset to global outline */
    outline: 2px solid ${({ theme }) => theme.colors.primary600};
    outline-offset: 2px;
    &:after {
      content: none;
    }
  }

  ${utils.getOptionStyle}
`;
const IconWrapper = styled__default.default.span `
  display: flex;
  align-items: center;
  svg {
    height: 4px;
    width: 6px;
  }
`;
const StyledButtonSmall = styled__default.default(Button.Button) `
  padding: ${({ theme }) => `${theme.spaces[1]} ${theme.spaces[3]}`};
`;
const MenuItem = ({ children, onClick = () => { }, to, isFocused = false, href, ...props }) => {
    const menuItemRef = React.useRef();
    React.useEffect(() => {
        if (isFocused && menuItemRef.current) {
            menuItemRef.current.focus();
        }
    }, [isFocused]);
    const menuItemProps = {
        tabIndex: isFocused ? 0 : -1,
        ref: menuItemRef,
        role: 'menuitem',
        ...props,
    };
    const handleKeyDown = (e) => {
        if (e.key === keyboardKeys.KeyboardKeys.SPACE || e.key === keyboardKeys.KeyboardKeys.ENTER) {
            onClick();
        }
    };
    if (to && !href) {
        return (jsxRuntime.jsx(OptionLink, { to: to, ...menuItemProps, children: jsxRuntime.jsx(Box.Box, { padding: 2, children: jsxRuntime.jsx(Typography.Typography, { children: children }) }) }));
    }
    if (href && !to) {
        return (jsxRuntime.jsx(OptionExternalLink, { isExternal: true, href: href, ...menuItemProps, children: jsxRuntime.jsx(Box.Box, { padding: 2, children: jsxRuntime.jsx(Typography.Typography, { children: children }) }) }));
    }
    return (jsxRuntime.jsx(OptionButton, { onKeyDown: handleKeyDown, onMouseDown: onClick, type: "button", ...menuItemProps, children: jsxRuntime.jsx(Box.Box, { padding: 2, children: jsxRuntime.jsx(Typography.Typography, { children: children }) }) }));
};
const SimpleMenu = ({ label, children, id, as: asComp, onOpen = () => { }, onClose = () => { }, size = 'M', popoverPlacement = 'bottom-start', onReachEnd, ...props }) => {
    const menuButtonRef = React.useRef(undefined);
    const menuId = useId.useId(id);
    const didMount = React.useRef(false);
    const [visible, setVisible] = React.useState(false);
    const [focusedItemIndex, setFocusItem] = React.useState(0);
    const childrenArray = React.Children.toArray(children);
    const DefaultComponent = size === 'S' ? StyledButtonSmall : Button.Button;
    const Component = asComp || DefaultComponent;
    const shouldHandleReachEnd = !!onReachEnd && typeof onReachEnd === 'function';
    React.useEffect(() => {
        if (['string', 'number'].includes(typeof label)) {
            // Useful to focus the selected item in the list
            const defaultItemIndexToFocus = childrenArray.findIndex((c) => (React__default.default.isValidElement(c) && c.props.children === label) || c === label);
            if (defaultItemIndexToFocus !== -1) {
                setFocusItem(defaultItemIndexToFocus);
            }
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [label]);
    const handleOpen = uiPrimitives.useCallbackRef(onOpen);
    const handleClose = uiPrimitives.useCallbackRef(onClose);
    React.useEffect(() => {
        if (didMount?.current) {
            if (visible) {
                handleOpen();
            }
            else {
                handleClose();
            }
        }
        else {
            didMount.current = true;
        }
    }, [didMount, handleClose, handleOpen, visible]);
    /* in case `label` is a custom react component, we know it is going to be
        a child of the menu button.
    */
    React.useEffect(() => {
        if (React__default.default.isValidElement(label) && focusedItemIndex === -1) {
            menuButtonRef.current.focus();
        }
    }, [label, focusedItemIndex]);
    const handleWrapperKeyDown = (e) => {
        if (visible) {
            if (e.key === keyboardKeys.KeyboardKeys.ESCAPE) {
                e.stopPropagation();
                setVisible(false);
                menuButtonRef.current.focus();
            }
            if (e.key === keyboardKeys.KeyboardKeys.DOWN) {
                setFocusItem((prev) => (prev === childrenArray.length - 1 ? 0 : prev + 1));
            }
            if (e.key === keyboardKeys.KeyboardKeys.UP) {
                setFocusItem((prev) => (prev === 0 ? childrenArray.length - 1 : prev - 1));
            }
        }
    };
    const handleKeyDown = (e) => {
        if (e.key === keyboardKeys.KeyboardKeys.ENTER || e.key === keyboardKeys.KeyboardKeys.SPACE) {
            setVisible((prevVisible) => !prevVisible);
        }
    };
    const handleBlur = (e) => {
        e.preventDefault();
        if (!e.currentTarget.contains(e.relatedTarget)) {
            setVisible(false);
        }
    };
    const handleMenuButtonMouseDown = (e) => {
        e.preventDefault();
        setVisible((prevVisible) => !prevVisible);
    };
    const handleReachEnd = () => {
        if (shouldHandleReachEnd) {
            onReachEnd();
        }
    };
    const childrenClone = childrenArray.map((child, index) => (
    // eslint-disable-next-line react/no-array-index-key
    jsxRuntime.jsx(Flex.Flex, { as: "li", justifyContent: "center", role: "menuitem", children: React__default.default.isValidElement(child)
            ? React.cloneElement(child, {
                onClick() {
                    child.props.onClick();
                    setVisible(false);
                    menuButtonRef.current.focus();
                },
                isFocused: focusedItemIndex === index,
            })
            : child }, index)));
    return (
    // TODO: review why we need to eslint it and how to solve this issue.
    // eslint-disable-next-line jsx-a11y/no-static-element-interactions
    jsxRuntime.jsxs("div", { onKeyDown: handleWrapperKeyDown, children: [jsxRuntime.jsx(Component, { label: React__default.default.isValidElement(label) ? null : label, "aria-haspopup": true, "aria-expanded": visible, "aria-controls": menuId, onKeyDown: handleKeyDown, onMouseDown: handleMenuButtonMouseDown, ref: menuButtonRef, type: "button", variant: "ghost", endIcon: jsxRuntime.jsx(IconWrapper, { children: jsxRuntime.jsx(icons.CarretDown, { "aria-hidden": true }) }), ...props, children: label }), visible && (jsxRuntime.jsx(Popover.Popover, { onBlur: handleBlur, placement: popoverPlacement, source: menuButtonRef, onReachEnd: handleReachEnd, intersectionId: shouldHandleReachEnd ? `popover-${menuId}` : undefined, spacing: 4, children: jsxRuntime.jsx(Box.Box, { role: "menu", as: "ul", padding: 1, id: menuId, children: childrenClone }) }))] }));
};

exports.MenuItem = MenuItem;
exports.SimpleMenu = SimpleMenu;
