'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const SelectParts = require('./SelectParts.js');
const strings = require('../helpers/strings.js');
const useComposeRefs = require('../hooks/useComposeRefs.js');
const useId = require('../hooks/useId.js');
const useIntersection = require('../hooks/useIntersection.js');
const Field = require('../Field/Field.js');
const Flex = require('../Flex/Flex.js');
const FieldLabel = require('../Field/FieldLabel.js');
const FieldHint = require('../Field/FieldHint.js');
const FieldError = require('../Field/FieldError.js');
const Box = require('../Box/Box.js');
const Typography = require('../Typography/Typography.js');

function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
    if (e) {
        for (const k in e) {
            if (k !== 'default') {
                const d = Object.getOwnPropertyDescriptor(e, k);
                Object.defineProperty(n, k, d.get ? d : {
                    enumerable: true,
                    get: () => e[k]
                });
            }
        }
    }
    n.default = e;
    return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);

const SingleSelect = React__namespace.forwardRef(({ error, hint, id, label, labelAction, required, selectButtonTitle: _deprecatedSelectButtonTitle, ...restProps }, forwardedRef) => {
    const generatedId = useId.useId(id);
    /**
     * Because the trigger needs to be a `div` to allow the clear
     * button & tags to be clickable, we need to manually focus it.
     */
    const triggerRef = React__namespace.useRef(null);
    const handleFieldLabelClick = () => {
        triggerRef.current.focus();
    };
    const composedTriggerRefs = useComposeRefs.useComposedRefs(forwardedRef, triggerRef);
    return (jsxRuntime.jsx(Field.Field, { hint: hint, error: error, id: generatedId, required: required, children: jsxRuntime.jsxs(Flex.Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [label ? (jsxRuntime.jsx(FieldLabel.FieldLabel, { onClick: handleFieldLabelClick, action: labelAction, children: label })) : null, jsxRuntime.jsx(SingleSelectInput, { label: label, id: generatedId, ref: composedTriggerRefs, required: required, ...restProps }), jsxRuntime.jsx(FieldHint.FieldHint, {}), jsxRuntime.jsx(FieldError.FieldError, {})] }) }));
});
const SingleSelectInput = React__namespace.forwardRef(({ 'aria-label': ariaLabel, id, children, clearLabel = 'Clear', customizeContent, disabled, error, label, onChange, onClear, onCloseAutoFocus, onReachEnd, placeholder, required, selectButtonTitle: _deprecatedSelectButtonTitle, startIcon, size = 'M', value: passedValue, ...restProps }, forwardedRef) => {
    /**
     * These values are drawn out from the internals of the Radix component
     * We can then use them to react to visual changes for the component
     */
    const [internalValue, setInternalValue] = React__namespace.useState();
    const [internalIsOpen, setInternalIsOpen] = React__namespace.useState(false);
    const handleOpenChange = (open) => {
        setInternalIsOpen(open);
    };
    const handleOnClear = (e) => {
        if (onClear) {
            onClear(e);
        }
        if (!onChange) {
            setInternalValue('');
        }
    };
    const hintId = `${id}-hint`;
    const errorId = `${id}-error`;
    const handleValueChange = (value) => {
        /**
         * If it's being externally managed then we shouldn't
         * both setting our copy of the internal value.
         */
        if (onChange) {
            const shouldBeNumber = typeof passedValue === 'number';
            onChange(shouldBeNumber ? Number(value) : value);
        }
        else {
            setInternalValue(value);
        }
    };
    const viewportRef = React__namespace.useRef(null);
    const generatedIntersectionId = useId.useId();
    const intersectionId = `intersection-${strings.stripReactIdOfColon(generatedIntersectionId)}`;
    const handleReachEnd = (entry) => {
        if (onReachEnd) {
            onReachEnd(entry);
        }
    };
    useIntersection.useIntersection(viewportRef, handleReachEnd, {
        selectorToWatch: `#${intersectionId}`,
        /**
         * We need to know when the select is open because only then will viewportRef
         * not be null. Because it uses a portal that (sensibly) is not mounted 24/7.
         */
        skipWhen: !internalIsOpen,
    });
    const value = (typeof passedValue !== 'undefined' && passedValue !== null ? passedValue.toString() : internalValue) ?? '';
    return (jsxRuntime.jsxs(SelectParts.Root, { onOpenChange: handleOpenChange, disabled: disabled, required: required, onValueChange: handleValueChange, value: value, ...restProps, children: [jsxRuntime.jsx(SelectParts.Trigger, { ref: forwardedRef, "aria-label": label ?? ariaLabel, "aria-describedby": id ? `${hintId} ${errorId}` : undefined, id: id, startIcon: startIcon, size: size, hasError: Boolean(error), disabled: disabled, clearLabel: clearLabel, onClear: value && onClear ? handleOnClear : undefined, children: jsxRuntime.jsx(SelectParts.Value, { placeholder: placeholder, textColor: value ? 'neutral800' : 'neutral600', children: value && customizeContent ? customizeContent(value) : undefined }) }), jsxRuntime.jsx(SelectParts.Portal, { children: jsxRuntime.jsx(SelectParts.Content, { position: "popper", sideOffset: 4, onCloseAutoFocus: onCloseAutoFocus, children: jsxRuntime.jsxs(SelectParts.Viewport, { ref: viewportRef, children: [children, jsxRuntime.jsx(Box.Box, { id: intersectionId, width: "100%", height: "1px" })] }) }) })] }));
});
const SingleSelectOption = React__namespace.forwardRef(({ value, startIcon, children, ...restProps }, ref) => {
    return (jsxRuntime.jsxs(SelectParts.Item, { ref: ref, value: value.toString(), ...restProps, children: [startIcon && (jsxRuntime.jsx(Box.Box, { as: "span", "aria-hidden": true, children: startIcon })), jsxRuntime.jsx(Typography.Typography, { textColor: "neutral800", children: jsxRuntime.jsx(SelectParts.ItemText, { children: children }) })] }));
});

exports.SingleSelect = SingleSelect;
exports.SingleSelectInput = SingleSelectInput;
exports.SingleSelectOption = SingleSelectOption;
