import { jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { MultiSelectOption, MultiSelect, MultiSelectGroup } from './MultiSelect.mjs';

const MultiSelectNested = ({ options, ...props }) => {
    return (jsx(MultiSelect, { ...props, children: options.map((opt) => {
            if ('children' in opt) {
                return (jsx(MultiSelectGroup, { label: opt.label, values: opt.children.map((child) => child.value.toString()), children: opt.children.map((child) => (jsx(NestedOption, { value: child.value, children: child.label }, child.value))) }, opt.label));
            }
            return (jsx(MultiSelectOption, { value: opt.value, children: opt.label }, opt.value));
        }) }));
};
const NestedOption = styled(MultiSelectOption) `
  padding-left: ${({ theme }) => theme.spaces[7]};
`;

export { MultiSelectNested };
