'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const useComposeRefs = require('../hooks/useComposeRefs.js');
const utils = require('../themes/utils.js');
const FieldInput = require('../Field/FieldInput.js');
const FieldAction = require('../Field/FieldAction.js');
const Field = require('../Field/Field.js');
const VisuallyHidden = require('../VisuallyHidden/VisuallyHidden.js');
const FieldLabel = require('../Field/FieldLabel.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const CloseIcon = styled__default.default(icons.Cross) `
  font-size: 0.5rem;
  path {
    fill: ${({ theme }) => theme.colors.neutral400};
  }
`;
const SearchIcon = styled__default.default(icons.Search) `
  font-size: 0.8rem;
  path {
    fill: ${({ theme }) => theme.colors.neutral800};
  }
`;
const SearchbarWrapper = styled__default.default.div `
  border-radius: ${({ theme }) => theme.borderRadius};
  box-shadow: ${({ theme }) => theme.shadows.filterShadow};

  &:focus-within {
    ${SearchIcon} {
      path {
        fill: ${({ theme }) => theme.colors.primary600};
      }
    }
  }

  ${FieldInput.InputWrapper} {
    border: 1px solid transparent;
  }

  ${utils.inputFocusStyle(FieldInput.InputWrapper)}
`;
const Searchbar = React.forwardRef(({ name, size = 'M', children, value = '', onClear, clearLabel, ...props }, ref) => {
    const inputRef = React.useRef(null);
    const isCompleting = value.length > 0;
    const handleClear = (e) => {
        onClear(e);
        inputRef.current.focus();
    };
    const actualRef = useComposeRefs.composeRefs(ref, inputRef);
    return (jsxRuntime.jsx(SearchbarWrapper, { children: jsxRuntime.jsxs(Field.Field, { name: name, children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: jsxRuntime.jsx(FieldLabel.FieldLabel, { children: children }) }), jsxRuntime.jsx(FieldInput.FieldInput, { ref: actualRef, value: value, startAction: jsxRuntime.jsx(SearchIcon, { "aria-hidden": true }), size: size, endAction: isCompleting ? (jsxRuntime.jsx(FieldAction.FieldAction, { label: clearLabel, onClick: handleClear, children: jsxRuntime.jsx(CloseIcon, {}) })) : undefined, ...props })] }) }));
});

exports.Searchbar = Searchbar;
