'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const Box = require('../Box/Box.js');

const RawTr = ({ children, ...props }) => {
    const childrenClone = React.Children.toArray(children).map((child, index) => {
        if (React.isValidElement(child)) {
            return React.cloneElement(child, {
                'aria-colindex': index + 1,
                coords: { col: index + 1, row: props['aria-rowindex'] },
            });
        }
        return child;
    });
    return (jsxRuntime.jsx(Box.Box, { as: "tr", ...props, children: childrenClone }));
};

exports.RawTr = RawTr;
