'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');

const RawThead = ({ children, ...props }) => {
    /**
     * aria-rowindex is 1-based: we have to start from 1
     */
    const childrenClone = React.Children.toArray(children).map((child) => {
        if (React.isValidElement(child)) {
            return React.cloneElement(child, { 'aria-rowindex': 1 });
        }
        return child;
    });
    return jsxRuntime.jsx("thead", { ...props, children: childrenClone });
};

exports.RawThead = RawThead;
