import { jsxs, jsx } from 'react/jsx-runtime';
import { BaseRadio } from '../BaseRadio/BaseRadio.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Typography } from '../Typography/Typography.mjs';

const Radio = ({ children, ...props }) => {
    return (jsxs(Flex, { alignItems: "center", as: "label", gap: 2, children: [jsx(BaseRadio, { ...props }), jsx(Typography, { textColor: "neutral800", children: children })] }));
};

export { Radio };
