import { jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Box } from '../Box/Box.mjs';

const ProgressbarBase = styled(Box) `
  &:before {
    background-color: ${({ theme }) => theme.colors.neutral0};
    border-radius: ${({ theme }) => theme.borderRadius};
    bottom: 0;
    content: '';
    position: absolute;
    top: 0;
    width: ${({ value }) => `${value}%`};
  }
`;
const ProgressBar = ({ min = 0, max = 100, value = 0, children, size = 'M', ...props }) => {
    return (jsx(ProgressbarBase, { background: "neutral600", hasRadius: true, "aria-label": children, "aria-valuemax": max, "aria-valuemin": min, "aria-valuenow": value, height: size === 'S' ? 1 : 2, position: "relative", role: "progressbar", value: value, width: size === 'S' ? '78px' : '102px', ...props }));
};

export { ProgressBar };
