import { jsx } from 'react/jsx-runtime';
import * as React from 'react';
import { createPortal } from 'react-dom';
import { Box } from '../Box/Box.mjs';

const Portal = React.forwardRef(({ container = globalThis?.document?.body, ...portalProps }, forwardedRef) => {
    return container ? createPortal(jsx(Box, { ref: forwardedRef, ...portalProps }), container) : null;
});
Portal.displayName = 'Portal';

export { Portal };
