import { jsx, jsxs } from 'react/jsx-runtime';
import { Cross } from '@strapi/icons';
import styled from 'styled-components';
import { useModal } from './ModalContext.mjs';
import { IconButton } from '../IconButton/IconButton.mjs';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';

const ModalHeaderWrapper = styled(Box) `
  border-radius: ${({ theme }) => theme.borderRadius} ${({ theme }) => theme.borderRadius} 0 0;
  border-bottom: 1px solid ${({ theme }) => theme.colors.neutral150};
`;
const ModalHeader = ({ children, closeLabel = 'Close the modal' }) => {
    const onClose = useModal();
    return (jsx(ModalHeaderWrapper, { paddingTop: 4, paddingBottom: 4, paddingLeft: 5, paddingRight: 5, background: "neutral100", children: jsxs(Flex, { justifyContent: "space-between", children: [children, jsx(IconButton, { onClick: onClose, "aria-label": closeLabel, icon: jsx(Cross, {}) })] }) }));
};

export { ModalHeader };
